*******************************************************************************
*                         680xx Grundprogramm basbef                          *
*                         (C) 1991 Ralph Dombrowski                           *
*                             2008 Jens Mewes                                 *
*                                 Rev 7.10                                    *
*                                01.01.2008                                   *
*                          Basisstart und Befehle                             *
*******************************************************************************


org 0                           * Auf Adresse Null bersetzen
offset setadr                   * Ablage wie voreingestellt

basis:
 dc.l stack+ram                 * Dummy Stack
 dc.l start                     * Startadresse bei Reset
 dc.l buserr                    * Busfehler
 dc.l adrerr                    * Adressfehler
 dc.l illins                    * Falscher Befehl
 dc.l zerdiv                    * Divison durch Null
 dc.l chkins                    * CHK-Befehl
 dc.l trapvins                  * Trapv-Befehl
 dc.l priv                      * Priviligierter Befehl
 dc.l tracein                   * Sprungadresse bei Trace
 dc.l linea+ram                 * Jetzt auch ins Ram gelenkt (Adresse fr 08/00)
 dc.l linef+ram                 * Fr Softwareschnittstelle mit FPU / PMMU
 dc.l $ffffffff                 * Reserviert
 dc.l $ffffffff                 * Coprozessor Protokol Verletzung (68020)
 dc.l format                    * Falsches Stackformat (Ab 68010)
 dc.l intlvx                    * Nicht initialisierter Interrupt
 df.l 8,$ffffffff               * Reserviert
 dc.l intlvx                    * Falscher Interrupt
 dc.l intlv1+ram                * Ebene 1
 dc.l intlv2+ram                * Ebene 2
 dc.l intlv3+ram                * Ebene 3
 dc.l intlv4+ram                * Ebene 4
 dc.l intlv5+ram                * Ebene 5
 dc.l intlv6+ram                * Ebene 6
 dc.l intlv7+ram                * Ebene 7
 dc.l trap0+ram                 * Alle Traps ins Ram gefhrt
 dc.l trap1+ram
 dc.l trap2+ram
 dc.l trap3+ram
 dc.l trap1+ram                 * Grundprogrammtrap unter CP/M
 dc.l trap1+ram                 * Reserve
 dc.l trap6+ram
 dc.l trap7+ram
 dc.l trap8+ram
 dc.l trap9+ram
 dc.l trap10+ram
 dc.l trap11+ram
 dc.l trap12+ram
 dc.l trap13+ram
 dc.l trap14+ram
 dc.l trap15+ram
 dc.l $ffffffff                 * FPU Sprung oder Setzen einer ungeordneten
                                * Bedingung (68020)
 dc.l $ffffffff                 * FPU Falsches Ergebnis (68020)
 dc.l $ffffffff                 * FPU Division durch Null (68020)
 dc.l $ffffffff                 * FPU Unterlauf (68020)
 dc.l $ffffffff                 * FPU Operanden Fehler (68020)
 dc.l $ffffffff                 * FPU berlauf (68020)
 dc.l $ffffffff                 * FPU Not a Number (68020)
 dc.l $ffffffff                 * Reserviert
 dc.l $ffffffff                 * PMMU Konfiguration (68020)
 dc.l $ffffffff                 * PMMU Falscher Befehl (68020)
 dc.l $ffffffff                 * PMMU Zugriffs Level Verletzung (68020)
 df.l 5,$ffffffff               * Reserviert

* Tabelle der Unterprogramme

traptab:
 dc.l tschreite                 * Befehl 1
 dc.l tdrehe                    * Befehl 2
 dc.l thoch                     * Befehl 3
 dc.l trunter                   * Befehl 4
 dc.l figurxy                   * Befehl 5
 dc.l textprint                 * Befehl 6
 dc.l tmove                     * Befehl 7
 dc.l moveto                    * Befehl 8
 dc.l drawto                    * Befehl 9
 dc.l textaus                   * Befehl 10
 dc.l textein                   * Befehl 11
 dc.l ci                        * Befehl 12
 dc.l csts                      * Befehl 13
 dc.l ri                        * Befehl 14
 dc.l poo                       * Befehl 15
 dc.l clrall                    * Befehl 16
 dc.l clrinvis                  * Befehl 17
 dc.l wait                      * Befehl 18
 dc.l tschr16tel                * Befehl 19
 dc.l clrscreen                 * Befehl 20
 dc.l co                        * Befehl 21
 dc.l lo2                       * Befehl 22
 dc.l sin                       * Befehl 23
 dc.l cos                       * Befehl 24
 dc.l setgroe                   * Befehl 25
 dc.l cmd                       * Befehl 26
 dc.l newpage                   * Befehl 27
 dc.l sync                      * Befehl 28
 dc.l wert                      * Befehl 29
 dc.l zuweis                    * Befehl 30
 dc.l ciinit2                   * Befehl 31
 dc.l ci2                       * Befehl 32
 dc.l co2                       * Befehl 33
 dc.l setflip                   * Befehl 34
 dc.l delay                     * Befehl 35
 dc.l firsttime                 * Befehl 36
 dc.l setpen                    * Befehl 37
 dc.l erapen                    * Befehl 38
 dc.l grapoff                   * Befehl 39
 dc.l print                     * Befehl 40
 dc.l print2x                   * Befehl 41
 dc.l print4x                   * Befehl 42
 dc.l print6x                   * Befehl 43
 dc.l print8x                   * Befehl 44
 dc.l print8b                   * Befehl 45
 dc.l print4d                   * Befehl 46
 dc.l hide                      * Befehl 47
 dc.l show                      * Befehl 48
 dc.l crtex                     * Befehl 49
 dc.l lstex                     * Befehl 50
 dc.l usrex                     * Befehl 51
 dc.l nilex                     * Befehl 52
 dc.l seterr                    * Befehl 53
 dc.l geterr                    * Befehl 54
 dc.l setpass                   * Befehl 55
 dc.l edit                      * Befehl 56
 dc.l figur                     * Befehl 57
 dc.l setfig                    * Befehl 58
 dc.l getram                    * Befehl 59
 dc.l autoflip                  * Befehl 60
 dc.l cursorein                 * Befehl 61
 dc.l cursoraus                 * Befehl 62
 dc.l charhandler               * Befehl 63
 dc.l progzge                   * Befehl 64
 dc.l assemble                  * Befehl 65
 dc.l getstx                    * Befehl 66
 dc.l putstx                    * Befehl 67
 dc.l getorg                    * Befehl 68
 dc.l putorg                    * Befehl 69
 dc.l print8d                   * Befehl 70
 dc.l printv8d                  * Befehl 71
 dc.l muls32                    * Befehl 72
 dc.l divs32                    * Befehl 73
 dc.l flinit                    * Befehl 74
 dc.l floppy                    * Befehl 75
 dc.l getflop                   * Befehl 76
 dc.l setxor                    * Befehl 77
 dc.l getxor                    * Befehl 78
 dc.l setcolor                  * Befehl 79
 dc.l getcolor                  * Befehl 80
 dc.l curonein                  * Befehl 81
 dc.l curonaus                  * Befehl 82
 dc.l adj360                    * Befehl 83
 dc.l symbolaus                 * Befehl 84
 dc.l symloesche                * Befehl 85
 dc.l getsymtab                 * Befehl 86
 dc.l getnext                   * Befehl 87
 dc.l putnext                   * Befehl 88
 dc.l getbasis                  * Befehl 89
 dc.l getvar                    * Befehl 90
 dc.l seta5                     * Befehl 91
 dc.l aufxy                     * Befehl 92
 dc.l korxy                     * Befehl 93
 dc.l aufk                      * Befehl 94
 dc.l getk                      * Befehl 95
 dc.l rnd                       * Befehl 96
 dc.l getvers                   * Befehl 97
 dc.l getsn                     * Befehl 98
 dc.l crlfe                     * Befehl 99
 dc.l getline                   * Befehl 100
 dc.l getcurxy                  * Befehl 101
 dc.l setcurxy                  * Befehl 102
 dc.l getxy                     * Befehl 103
 dc.l si                        * Befehl 104
 dc.l so                        * Befehl 105
 dc.l sists                     * Befehl 106
 dc.l sosts                     * Befehl 107
 dc.l siinit                    * Befehl 108
 dc.l getad8                    * Befehl 109
 dc.l getad10                   * Befehl 110
 dc.l setda                     * Befehl 111
 dc.l speak                     * Befehl 112
 dc.l speak1                    * Befehl 113
 dc.l sound                     * Befehl 114
 dc.l getuhr                    * Befehl 115
 dc.l setuhr                    * Befehl 116
 dc.l lsts                      * Befehl 117
 dc.l relaisan                  * Befehl 118
 dc.l relaisaus                 * Befehl 119
 dc.l asserr                    * Befehl 120
 dc.l tnotimp                   * Befehl 121    Nur beim 68020
 dc.l tnotimp                   * Befehl 122    Nur beim 68020
 dc.l readaus                   * Befehl 123
 dc.l grund                     * Befehl 124
 dc.l hardcopy                  * Befehl 125
 dc.l grafik                    * Befehl 126
 dc.l gdpvers                   * Befehl 127
 dc.l seraus                    * Befehl 128
 dc.l serex                     * Befehl 129
 dc.l clutinit                  * Befehl 130
 dc.l clut                      * Befehl 131
 dc.l relais                    * Befehl 132
 dc.l relaisin                  * Befehl 133
 dc.l setda12                   * Befehl 134
 dc.l getad12                   * Befehl 135
 dc.l suchbibo                  * Befehl 136
 dc.l trapdisass                * Befehl 137
 dc.l si2                       * Befehl 138
 dc.l system                    * Befehl 139
 dc.l uhrprint                  * Befehl 140
 dc.l harddisk                  * Befehl 141
 dc.l hardtest                  * Befehl 142
 dc.l tnotimp                   * Befehl 143    Reserviert
 dc.l tnotimp                   * Befehl 144    Reserviert
 dc.l tnotimp                   * Befehl 145    Nur bei 68020
 dc.l tnotimp                   * Befehl 146    Nur bei 68020
 dc.l tnotimp                   * Befehl 147    Nur bei 68020
 dc.l tnotimp                   * Befehl 148    Nur bei 68020
 dc.l tnotimp                   * Befehl 149    Nur bei 68020
 dc.l setser                    * Befehl 150
 dc.l getser                    * Befehl 151
 dc.l sets2i                    * Befehl 152
 dc.l gets2i                    * Befehl 153
 dc.l idetest                   * Befehl 154
 dc.l idedisk                   * Befehl 155
 dc.l srdisk                    * Befehl 156
 dc.l setf2s                    * Befehl 157
 dc.l getf2s                    * Befehl 158
 dc.l getsrd                    * Befehl 159
 dc.l setsys                    * Befehl 160
 dc.l getsys                    * Befehl 161
 dc.l patch                     * Befehl 162
 dc.l sdtest                    * Befehl 163
 dc.l sddisk                    * Befehl 164
 dc.l setchar                   * Befehl 165
 dc.l settrans                  * Befehl 166
 dc.l gettrans                  * Befehl 167



trapende:

maxtraps equ (trapende-traptab)/4       * Anzahl der Befehle

 df.l 192-maxtraps,tnotimp      * Auffllen, dadurch weiter mit Adresse $400


 dc.l $5aa58001                 * Suchstring fr Anfang

ramstart:
 dc.l ram                       * Ramanfang (Basis mu addiert werden)
 dc.l start                     * Pointer auf Startadresse
versnum:
 dc.l $00000710                 * Version 7.10
snnum:
 dc.l $00000003                 * Revisionsnummer (vormals Seriennummer)
cpuwert:
 dc.l cpu                       * CPU  (1,2,4 fr 68008, 68000 und 68020)
 dc.l (ende-basis)/2            * Lnge des Grundprogramms in Worten fr Check
 dc.l 0                         * Checksumme (Wortweise gebildet)
                                * Alle Worte bis auf die 2 Worte der Prfsumme

 bra traprts                    * Start-Trap mit RTS-Abschlu
 bra start                      * Kalt-Start
 bra exinit                     * Externes Init
 bra warmstart                  * Sprung in Men

trapsym:                        * Symbole fr Trap-Tabelle
 dc.b 'SCHREITE'                * 1
 dc.b 'DREHE   '                * 2
 dc.b 'HEBE    '                * 3
 dc.b 'SENKE   '                * 4
 dc.b 'FIGURXY '                * 5
 dc.b 'WRITELF '                * 6
 dc.b 'SET     '                * 7
 dc.b 'MOVETO  '                * 8
 dc.b 'DRAWTO  '                * 9
 dc.b 'WRITE   '                * 10
 dc.b 'READ    '                * 11
 dc.b 'CI      '                * 12
 dc.b 'CSTS    '                * 13
 dc.b 'RI      '                * 14
 dc.b 'PO      '                * 15
 dc.b 'CLR     '                * 16
 dc.b 'CLPG    '                * 17
 dc.b 'WAIT    '                * 18
 dc.b 'SCHR16TE'                * 19
 dc.b 'CLRSCREE'                * 20
 dc.b 'CO      '                * 21
 dc.b 'LO      '                * 22
 dc.b 'SIN     '                * 23
 dc.b 'COS     '                * 24
 dc.b 'SIZE    '                * 25
 dc.b 'CMD     '                * 26
 dc.b 'NEWPAGE '                * 27
 dc.b 'SYNC    '                * 28
 dc.b 'WERT    '                * 29
 dc.b 'ZUWEIS  '                * 30
 dc.b 'CIINIT2 '                * 31
 dc.b 'CI2     '                * 32
 dc.b 'CO2     '                * 33
 dc.b 'SETFLIP '                * 34
 dc.b 'DELAY   '                * 35
 dc.b 'FIRSTTIM'                * 36
 dc.b 'SETPEN  '                * 37
 dc.b 'ERAPEN  '                * 38
 dc.b 'GRAPOFF '                * 39
 dc.b 'CMDPRINT'                * 40
 dc.b 'PRINT2X '                * 41
 dc.b 'PRINT4X '                * 42
 dc.b 'PRINT6X '                * 43
 dc.b 'PRINT8X '                * 44
 dc.b 'PRINT8B '                * 45
 dc.b 'PRINT4D '                * 46
 dc.b 'HIDE    '                * 47
 dc.b 'SHOW    '                * 48
 dc.b 'CRT     '                * 49
 dc.b 'LST     '                * 50
 dc.b 'USR     '                * 51
 dc.b 'NIL     '                * 52
 dc.b 'SETERR  '                * 53
 dc.b 'GETERR  '                * 54
 dc.b 'SETPASS '                * 55
 dc.b 'EDIT    '                * 56
 dc.b 'FIGUR   '                * 57
 dc.b 'SETFIG  '                * 58
 dc.b 'GETRAM  '                * 59
 dc.b 'AUTOFLIP'                * 60
 dc.b 'CURSEIN '                * 61
 dc.b 'CURSAUS '                * 62
 dc.b 'CHAR    '                * 63
 dc.b 'PROGZGE '                * 64
 dc.b 'ASSEMBLE'                * 65
 dc.b 'GETSTX  '                * 66
 dc.b 'PUTSTX  '                * 67
 dc.b 'GETORG  '                * 68
 dc.b 'PUTORG  '                * 69
 dc.b 'PRINT8D '                * 70
 dc.b 'PRINTV8D'                * 71
 dc.b 'MULS32  '                * 72
 dc.b 'DIVS32  '                * 73
 dc.b 'FLINIT  '                * 74
 dc.b 'FLOPPY  '                * 75
 dc.b 'GETFLOP '                * 76
 dc.b 'SETXOR  '                * 77
 dc.b 'GETXOR  '                * 78
 dc.b 'SETCOLOR'                * 79
 dc.b 'GETCOLOR'                * 80
 dc.b 'CURON   '                * 81
 dc.b 'CUROFF  '                * 82
 dc.b 'ADJ360  '                * 83
 dc.b 'PRTSYM  '                * 84
 dc.b 'SYMCLR  '                * 85
 dc.b 'GETSYM  '                * 86
 dc.b 'GETNEXT '                * 87
 dc.b 'PUTNEXT '                * 88
 dc.b 'GETBASIS'                * 89
 dc.b 'GETVAR  '                * 90
 dc.b 'SETA5   '                * 91
 dc.b 'AUFXY   '                * 92
 dc.b 'KORXY   '                * 93
 dc.b 'AUFK    '                * 94
 dc.b 'GETK    '                * 95
 dc.b 'RND     '                * 96
 dc.b 'GETVERS '                * 97
 dc.b 'GETSN   '                * 98
 dc.b 'CRLF    '                * 99
 dc.b 'GETLINE '                * 100
 dc.b 'GETCURXY'                * 101
 dc.b 'SETCURXY'                * 102
 dc.b 'GETXY   '                * 103
 dc.b 'SI      '                * 104
 dc.b 'SO      '                * 105
 dc.b 'SISTS   '                * 106
 dc.b 'SOSTS   '                * 107
 dc.b 'SIINIT  '                * 108
 dc.b 'GETAD8  '                * 109
 dc.b 'GETAD10 '                * 110
 dc.b 'SETDA   '                * 111
 dc.b 'SPEAK   '                * 112
 dc.b 'SPEAK1  '                * 113
 dc.b 'SOUND   '                * 114
 dc.b 'GETUHR  '                * 115
 dc.b 'SETUHR  '                * 116
 dc.b 'LSTS    '                * 117
 dc.b 'RELAN   '                * 118
 dc.b 'RELAUS  '                * 119
 dc.b 'ASSERR  '                * 120
 dc.b '::::::::'                * 121           Nur fr 68020
 dc.b '::::::::'                * 122           Nur bei 68020
 dc.b 'READAUS '                * 123
 dc.b 'GRUND   '                * 124
 dc.b 'HARDCOPY'                * 125
 dc.b 'GRAFIK  '                * 126
 dc.b 'GDPVERS '                * 127
 dc.b 'SER     '                * 128
 dc.b 'CO2SER  '                * 129
 dc.b 'CLUTINIT'                * 130
 dc.b 'CLUT    '                * 131
 dc.b 'RELAIS  '                * 132
 dc.b 'RELAISIN'                * 133
 dc.b 'SETDA12 '                * 134
 dc.b 'GETAD12 '                * 135
 dc.b 'SUCHBIBO'                * 136
 dc.b 'DISASS  '                * 137
 dc.b 'SI2     '                * 138
 dc.b 'SYSTEM  '                * 139
 dc.b 'UHRPRINT'                * 140
 dc.b 'HARDDISK'                * 141
 dc.b 'HARDTEST'                * 142
 dc.b '::::::::'                * 143           Reserviert
 dc.b '::::::::'                * 144           Reserviert
 dc.b '::::::::'                * 145           Nur bei 68020
 dc.b '::::::::'                * 146           Nur bei 68020
 dc.b '::::::::'                * 147           Nur bei 68020
 dc.b '::::::::'                * 148           Nur bei 68020
 dc.b '::::::::'                * 149           Nur bei 68020
 dc.b 'SETSER  '                * 150
 dc.b 'GETSER  '                * 151
 dc.b 'SETS2I  '                * 152
 dc.b 'GETS2I  '                * 153
 dc.b 'IDETEST '                * 154
 dc.b 'IDEDISK '                * 155
 dc.b 'SRDISK  '                * 156
 dc.b 'SETF2S  '                * 157
 dc.b 'GETF2S  '                * 158
 dc.b 'GETSRD  '                * 159
 dc.b 'SETSYS  '                * 160
 dc.b 'GETSYS  '                * 161
 dc.b 'PATCH   '                * 162
 dc.b 'SDTEST  '                * 163
 dc.b 'SDDISK  '                * 164
 dc.b 'SETCHAR '                * 165
 dc.b 'SETTRANS'                * 166
 dc.b 'GETTRANS'                * 167
 dc.l 0,0                       * Ende

                                                                                                                                 .Wnݷot7{?Xo_~߅u?=];|n_1{._K9_]sa'_뾶}chG?Os.;LFP?icގ}S7}ӏϿ;5jkEo7nG=s=5?;Or+/m]:_$|z}}{o^}WrYQy>~Qػwzv]:&q}Ϗ|/nϞn<Y?	N{]^O.moտϗɏQvg޹]k3nﾊ3{7xޟ_lz_	g?z7w